/*
2012 - SOCOMEC SICON S.r.l.
*/

var barClicked;
var cornerSettings = "top 3px";
var fields;

//Arrotondi gli angoli ai pulsanti
$("#measurementsBarButton").corner(cornerSettings);
$("#_measurements").corner(cornerSettings);

$("#eventsLogBarButton").corner(cornerSettings);
$("#emailBarButton").corner(cornerSettings);
$("#shutdownBarButton").corner(cornerSettings);
$("#miscBarButton").corner(cornerSettings);
$("#communicationBarButton").corner(cornerSettings);


//*****************************
//PAGE FUNCTIONS 
//*****************************

$(document).ready(function () {

    $('#upbar').load('upbar.html');

    //Popolo le dropdown list
    populateCbo("interface");

    //Applico lo stile ai pulsanti
    $("#radioInterval").buttonset();

    $("#submitSaveCommunication").button();
    $("#btnAutoDiscover").button();
    $("#submitSaveEmail").button();
    $("#submitSaveShutdown").button();
    $("#submitSaveMisc").button();

    $("#exportMeasLog").button();
    $("#exportEventsLog").button();
    $("#sendMailTest").button();
    $("#startShutdownTest").button();
    $("#cancelShutdownTest").button();
    
    $("#checkUpdate").button();


    loadingText(); //Barra rossa LOADING

    //---------------
    // Dialog box
    //---------------

    // if user clicked on button, the overlay layer or the dialogbox, close the dialog  
    $('a.btn-ok, #dialog-overlay, #dialog-box').click(function () {
        $('#dialog-overlay, #dialog-box').hide();
        return false;
    });

    // if user resize the window, call the same function again
    // to make sure the overlay fills the screen and dialogbox aligned to center    
    $(window).resize(function () {

        //only do it if the dialog box is not hidden
        if (!$('#dialog-box').is(':hidden')) popup();
    }); 
});



$(function () {

    $("select#interface").change(function () { //Controllo drop down list INTERFACE
        divRule("interface");
    })

    $("input[name='dataRecordPeriod']:radio").change(function () {
        divRule("dataRecordPeriod");
    })

    $('input#cbFirstDelayScript').change(function () {
        divRule("cbFirstDelayScript");
    });

    $('input#cbShutdownCommandScript').change(function () {
        divRule("cbShutdownCommandScript");
    });

    $("input[name='radioInterval']:radio").change(function () {
        loadEventsLog();
    })

    //-------------------------------------------
    // Salvataggio dati pannello Communication
    //-------------------------------------------

    $("#submitSaveCommunication").click(function () {

        //Nascondo le label degli errorifinterface
        $(".contenuto-box-bianco-controllo label").hide();

        var fields = getFieldsPanelData("barraCommunication");

        //Recupero i dati inseriti
        fields = getValuesFromPanel(fields);

        //Validazione dei dati inseriti
        var valOk = true;
        $.each(fields, function (i, field) {
            switch (field.name) {
                case "tcpPort":
                    var interface = $("select#interface").val();
                    if ((interface == "ETH") && ((TryParseInt(field.value) == false) || (!field.value))) {
                        $("label#tcpPort_error").show();
                        $("input#tcpPort").focus();
                        valOk = false;
                    }
                    break;

                case "ipAddress":
                    var interface = $("select#interface").val();
                    if ((interface == "ETH") && ((isValidIPAddress(field.value) == false) || (!field.value))) {
                        $("label#ipAddress_error").show();
                        $("input#ipAddress").focus();
                        valOk = false;
                    }
                    break;
            }
        });
        if (valOk == false) return false;

        //Salvo i dati
        saveData(fields,
                 eUrlPost.saveCommDbValue);

        return false;
    });

    //-------------------------------------------
    // Salvataggio dati pannello Miscellaneus
    //-------------------------------------------

    $("#submitSaveMisc").click(function () {

        //Nascondo le label degli errori
        $(".contenuto-box-bianco-controllo label").hide();
        $("#httpPort_error").hide();
        

        var fields = getFieldsPanelData("barraMisc");

        //Recupero i dati inseriti
        fields = getValuesFromPanel(fields);

        //Validazione dei dati inseriti
        var valOk = true;
        $.each(fields, function (i, field) {
            switch (field.name) {
                case "httpPort":
                    if ((TryParseInt(field.value) == false) || (!field.value)) {
                        $("label#httpPort_error").show();
                        $("input#httpPort").focus();
                        valOk = false;
                    }
                    break;
            }
        });
        if (valOk == false) return false;

        //Salvo i dati
        saveData(fields,
                 eUrlPost.saveUserDbValue);

        pageTranslate();

        return false;
    });

    //-------------------------------------------
    // Salvataggio dati pannello Shutdown
    //-------------------------------------------

    $("#submitSaveShutdown").click(function () {

        //Nascondo le label degli errori
        $(".contenuto-box-bianco-controllo label").hide();
        $(".emailEventTable-error").hide();

        var fields = getFieldsPanelData("barraShutDown");

        //Recupero i dati inseriti
        fields = getValuesFromPanel(fields);

        //Validazione dei dati inseriti
        var valOk = true;
        $.each(fields, function (i, field) {
            switch (field.name) {
                case "FirstWarning":
                    if ((TryParseInt(field.value) == false) || (!field.value)) {
                        $("label#shutDownFirstWarning_error").show();
                        $("input#shutDownFirstWarning").focus();
                        valOk = false;
                    }
                    break;

                case "SDDelay":
                    if ((TryParseInt(field.value) == false) || (!field.value)) {
                        $("label#shutDownDelay_error").show();
                        $("input#shutDownDelay").focus();
                        valOk = false;
                    }
                    break;

                case "UPS_SDDelay":
                    if ((TryParseInt(field.value) == false) || (!field.value)) {
                        $("label#shutdownUpsShutoffDelay_error").show();
                        $("input#shutdownUpsShutoffDelay").focus();
                        valOk = false;
                    }
                    break;

                case "es001delay": //shutdownEventOnBatteryDelayS
                    if ((TryParseInt(field.value) == false) || (!field.value)) {
                        $("label#shutdownEventOnBatteryDelayS_error").show();
                        $("input#shutdownEventOnBatteryDelayS").focus();
                        valOk = false;
                    }
                    break;

                case "es002delay": //shutdownEventOverloadDelayS
                    if ((TryParseInt(field.value) == false) || (!field.value)) {
                        $("label#shutdownEventOverloadDelayS_error").show();
                        $("input#shutdownEventOverloadDelayS").focus();
                        valOk = false;
                    }
                    break;

                case "es003delay": //shutdownEventOverTemperatureDelayS
                    if ((TryParseInt(field.value) == false) || (!field.value)) {
                        $("label#shutdownEventOverTemperatureDelayS_error").show();
                        $("input#shutdownEventOverTemperatureDelayS").focus();
                        valOk = false;
                    }
                    break;

                case "es004delay": //shutdownEventBatteryLowDelayS
                    if ((TryParseInt(field.value) == false) || (!field.value)) {
                        $("label#shutdownEventBatteryLowDelayS_error").show();
                        $("input#shutdownEventBatteryLowDelayS").focus();
                        valOk = false;
                    }
                    break;

                case "es005delay": //shutdownEventImminentStopDelayS
                    if ((TryParseInt(field.value) == false) || (!field.value)) {
                        $("label#shutdownEventImminentStopDelayS_error").show();
                        $("input#shutdownEventImminentStopDelayS").focus();
                        valOk = false;
                    }
                    break;

                case "es006delay": //shutdownEventOnBypassDelayS
                    if ((TryParseInt(field.value) == false) || (!field.value)) {
                        $("label#shutdownEventOnBypassDelayS_error").show();
                        $("input#shutdownEventOnBypassDelayS").focus();
                        valOk = false;
                    }
                    break;

            }
        });
        if (valOk == false) return false;

        //Salvo i dati
        saveData(fields,
                 eUrlPost.saveUserDbValue);

        return false;


    });

    //-------------------------------------------
    // Salvataggio dati pannello Email
    //-------------------------------------------

    $("#submitSaveEmail").click(function () {
        //Nascondo le label degli errori
        $(".contenuto-box-bianco-controllo label").hide();
        $(".emailEventTable-error").hide();


        var fields = getFieldsPanelData("barraEmail");

        //Recupero i dati inseriti
        fields = getValuesFromPanel(fields);

        //Validazione dei dati inseriti
        var valOk = true;
        $.each(fields, function (i, field) {
            switch (field.name) {
                case "ServerAddress":
                    //if ((isValidIPAddress(field.value) == false) || (!field.value)) {
                    if (!field.value) {
                        $("label#emailServer_error").show();
                        $("input#emailServer").focus();
                        valOk = false;
                    }
                    break;

                case "Port":
                    if ((TryParseInt(field.value) == false) || (!field.value)) {
                        $("label#emailPort_error").show();
                        $("input#emailPort").focus();
                        valOk = false;
                    }
                    break;

                case "DelayInMinutes":
                    if ((TryParseInt(field.value) == false) || (!field.value)) {
                        $("label#receiverEmailDelay_error").show();
                        $("input#receiverEmailDelay").focus();
                        valOk = false;
                    }
                    break;

                case "IntervalInHours":
                    if ((TryParseInt(field.value) == false) || (!field.value)) {
                        $("label#receiverInterval_error").show();
                        $("input#receiverInterval").focus();
                        valOk = false;
                    }
                    break;

                case "ReceiverAddress1":
                    if ((isValidMailAddress(field.value) == false)) {
                        $("label#receiverAddress1_error").show();
                        $("input#receiverAddress1").focus();
                        valOk = false;
                    }
                    break;

                case "ReceiverAddress2":
                    if ((isValidMailAddress(field.value) == false)) {
                        $("label#receiverAddress2_error").show();
                        $("input#receiverAddress2").focus();
                        valOk = false;
                    }
                    break;

                case "ReceiverAddress3":
                    if ((isValidMailAddress(field.value) == false)) {
                        $("label#receiverAddress3_error").show();
                        $("input#receiverAddress3").focus();
                        valOk = false;
                    }
                    break;

                case "ReceiverAddress4":
                    if ((isValidMailAddress(field.value) == false)) {
                        $("label#receiverAddress4_error").show();
                        $("input#receiverAddress4").focus();
                        valOk = false;
                    }
                    break;

                case "ReceiverAddress5":
                    if ((isValidMailAddress(field.value) == false)) {
                        $("label#receiverAddress5_error").show();
                        $("input#receiverAddress5").focus();
                        valOk = false;
                    }
                    break;

                case "ReceiverAddress6":
                    if ((isValidMailAddress(field.value) == false)) {
                        $("label#receiverAddress6_error").show();
                        $("input#receiverAddress6").focus();
                        valOk = false;
                    }
                    break;

                case "ReceiverAddress7":
                    if ((isValidMailAddress(field.value) == false)) {
                        $("label#receiverAddress7_error").show();
                        $("input#receiverAddress7").focus();
                        valOk = false;
                    }
                    break;

                case "ReceiverAddress8":
                    if ((isValidMailAddress(field.value) == false)) {
                        $("label#receiverAddress8_error").show();
                        $("input#receiverAddress8").focus();
                        valOk = false;
                    }
                    break;
            }
        });
        if (valOk == false) return false;

        //Salvo i dati
        saveData(fields,
                 eUrlPost.saveUserDbValue);

        return false;


    });
});

//*****************************
//EXPERT FUNCTIONS
//*****************************

function clockViewer() { }


function getValuesFromPanel(fields) {
    //Recupero i dati inseriti
    $.each(fields, function (i, field) {
        switch (field.type) {
            case eDivType.checkBox:
                field.value = getCbValue(field.divName);
                break;

            case eDivType.radio:
                field.value = $("input:radio[name=" + field.divName + "]:checked").val();
                break;

            case eDivType.value:
                field.value = $("input#" + field.divName).val();
                break;

            case eDivType.selection:
                field.value = $("select#" + field.divName).val();
                break;
        }
    });
    return fields;
}

function partialDivName(divName) {
    return divName.lastIndexOf("#");
}

function getCbValue(comboBoxName){
    var cbValue;
    if ($("input#" + comboBoxName + ":checked").val() == "on") {
                cbValue = "ENABLED";
            } else {
                cbValue = "DISABLED";
            }
    return cbValue;
}



function loadPanels() {
    //Visualizza la versione


    hideAll();
    barClick("barraHistory");
}

function toolEnhancing(data) {
    toolEnhancingUpperBar(data);
}

function pageTranslate() {
    var fieldsPage = new Array;

    //Header - Primo livello pulsanti
    fieldsPage.push({ divName: '', value: 'HISTORY', name: 'historyText', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'CONFIGURATION', name: 'configText', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'HELP', name: 'helpText', type: eDivType.div });
    
    //Header - Secondo livello pulsanti
    fieldsPage.push({ divName: '', value: 'MESUREMENTS', name: '_measurements', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'EVENT LOG', name: '_events', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'E-MAIL', name: '_email', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'SHUTDOWN', name: '_shutdown', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'MISCELLANEOUS', name: '_miscellaneus', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'COMMUNICATION', name: '_communication', type: eDivType.div });
    
    //Communication Panel
    fieldsPage.push({ divName: '', value: 'COMMUNICATION', name: 'tbCommunicationTitle', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'UPS Protocol Type', name: 'tbProtocol', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Interface', name: 'tbInterface', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Slave ID', name: 'tbSlaveID', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'COM Speed', name: 'tbCOMSpeed', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'TCP Port', name: 'tbTCPPort', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'TCP Address', name: 'tbTCPAddress', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Local UPS AutoDiscover', name: 'btnAutoDiscover', type: eDivType.button });
    fieldsPage.push({ divName: '', value: 'SAVE', name: 'submitSaveCommunication', type: eDivType.button });
    
    //Misc Panel
    fieldsPage.push({ divName: '', value: 'LANGUAGE SELECTION', name: 'tbLanguageSelection', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Data Record', name: 'lbDataRecordPeriod', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'By DAY', name: 'tbByDay', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'By WEEK', name: 'tbByWeek', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'By MONTH', name: 'tbByMonth', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Data Sample (minutes)', name: 'lbDataSample', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'SAVE', name: 'submitSaveMisc', type: eDivType.button });
    fieldsPage.push({ divName: '', value: 'MEASUREMENTS FILTER', name: 'tbMeasurementsFilter', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Http Port', name: 'tbHttpPort', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Http Port', name: 'httpPortLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'Check for updates', name: 'checkUpdate', type: eDivType.button });
    
    //Shutdown Panel
    fieldsPage.push({ divName: '', value: 'SHUTDOWN CONFIGURATION', name: 'tbShutDownConfiguration', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'First Warning (s):', name: 'shutDownFirstWarningLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'Shutdown Delay (s):', name: 'shutDownDelayLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'First Delay Script:', name: 'fileFirstDelayScriptLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'Shutdown Command Script:', name: 'fileShutdownCommandScriptLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'SHUTDOWN EVENTS', name: 'tbShutdownEvents', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'First Delay (s)', name: 'tbFirstDelay', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Enabled', name: 'tbEnabled', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Event', name: 'tbEvent', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'ES001', name: 'shutdownEventOnBatteryDelaySLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'ES002', name: 'shutdownEventOverloadDelaySLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'ES003', name: 'shutdownEventOverTemperatureDelaySLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'First Delay (s)', name: 'tbFirstDelay2', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Enabled', name: 'tbEnabled2', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Event', name: 'tbEvent2', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'ES004', name: 'shutdownEventBatteryLowDelaySLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'ES005', name: 'shutdownEventImminentStopDelaySLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'ES006', name: 'shutdownEventOnBypassDelaySLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'UPS SHUTOFF CONFIGURATION', name: 'tbUpsShutoffConfiguration', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'UPS Shutoff Enabled', name: 'shutdownUpsShutOffLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'UPS Shutdown Delay (s):', name: 'shutdownUpsShutoffDelayLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'TEST COMMANDS', name: 'tbTestCommands', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Start Shutdown Test', name: 'startShutdownTest', type: eDivType.button });
    fieldsPage.push({ divName: '', value: 'Cancel Shutdown Test', name: 'cancelShutdownTest', type: eDivType.button });
    fieldsPage.push({ divName: '', value: 'SAVE', name: 'submitSaveShutdown', type: eDivType.button });
    
    //Email Panel
    fieldsPage.push({ divName: '', value: 'SMTP', name: 'tbSmtpServerConfiguration', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Server:', name: 'emailServerLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'Port:', name: 'emailPortLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'Account:', name: 'emailAccountLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'Authentication:', name: 'emailAuthenticationLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'Password:', name: 'emailPasswordLabel', type: eDivType.label });	
	fieldsPage.push({ divName: '', value: 'SenderMailAddress:', name: 'emailSenderMailAddressLabel', type: eDivType.label });
	fieldsPage.push({ divName: '', value: 'SSL:', name: 'emailSSLLabel', type: eDivType.label });
	
    fieldsPage.push({ divName: '', value: 'EVENTS', name: 'tbEvents', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Info', name: 'tbCriticalityLevelOnBatteryinfo', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Warning', name: 'tbCriticalityLevelOnBatteryWarning', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Critical', name: 'tbCriticalityLevelOnBatteryCritical', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Info', name: 'criticalityLevelOverloadInfo', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Warning', name: 'criticalityLevelOverloadWarning', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Critical', name: 'criticalityLevelOverloadCritical', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Info', name: 'criticalityLevelOverTemperatureInfo', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Warning', name: 'criticalityLevelOverTemperatureWarning', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Critical', name: 'criticalityLevelOverTemperatureCritical', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Info', name: 'criticalityLevelGeneralAlarmInfo', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Warning', name: 'criticalityLevelGeneralAlarmWarning', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Critical', name: 'criticalityLevelGeneralAlarmCritical', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Info', name: 'criticalityLevelBatteryAlarmInfo', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Warning', name: 'criticalityLevelBatteryAlarmWarning', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Critical', name: 'criticalityLevelBatteryAlarmCritical', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Info', name: 'criticalityLevelBatteryDischargedInfo', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Warning', name: 'criticalityLevelBatteryDischargedWarning', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Critical', name: 'criticalityLevelBatteryDischargedCritical', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Info', name: 'criticalityLevelImminentStopInfo', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Warning', name: 'criticalityLevelImminentStopWarning', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Critical', name: 'criticalityLevelImminentStopCritical', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Info', name: 'criticalityLevelOnBypassInfo', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Warning', name: 'criticalityLevelOnBypassWarning', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Critical', name: 'criticalityLevelOnBypassCritical', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'RECEIVERS', name: 'tbReceivers', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Delay (min):', name: 'receiverEmailDelayLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'Interval (h):', name: 'receiverIntervalLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'Send_Test_EMail', name: 'sendMailTest', type: eDivType.button });
    fieldsPage.push({ divName: '', value: 'Receiver Address', name: 'receiverAddressLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'Description', name: 'receiverDescriptionLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'Minimum Alarm Criticity', name: 'receiversMinAlarm', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'Info', name: 'minAlarmCritic1Info', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Warning', name: 'minAlarmCritic1Warning', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Critical', name: 'minAlarmCritic1Critical', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Info', name: 'minAlarmCritic2Info', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Warning', name: 'minAlarmCritic2Warning', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Critical', name: 'minAlarmCritic2Critical', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Info', name: 'minAlarmCritic3Info', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Warning', name: 'minAlarmCritic3Warning', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Critical', name: 'minAlarmCritic3Critical', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Info', name: 'minAlarmCritic4Info', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Warning', name: 'minAlarmCritic4Warning', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Critical', name: 'minAlarmCritic4Critical', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Info', name: 'minAlarmCritic5Info', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Warning', name: 'minAlarmCritic5Warning', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Critical', name: 'minAlarmCritic5Critical', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Info', name: 'minAlarmCritic6Info', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Warning', name: 'minAlarmCritic6Warning', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Critical', name: 'minAlarmCritic6Critical', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Info', name: 'minAlarmCritic7Info', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Warning', name: 'minAlarmCritic7Warning', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Critical', name: 'minAlarmCritic7Critical', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Info', name: 'minAlarmCritic8Info', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Warning', name: 'minAlarmCritic8Warning', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'Critical', name: 'minAlarmCritic8Critical', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'SAVE', name: 'submitSaveEmail', type: eDivType.button });
    fieldsPage.push({ divName: '', value: 'EM001', name: 'emailEventOnBatteryLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'EM002', name: 'emailEventOverloadLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'EM003', name: 'emailEventOverTemperatureLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'EM004', name: 'emailEventGeneralAlarmLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'EM005', name: 'emailEventBatteryAlarmLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'EM006', name: 'emailEventBatteryDischargedLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'EM007', name: 'emailEventImminentStopLabel', type: eDivType.label });
    fieldsPage.push({ divName: '', value: 'EM008', name: 'emailEventOnBypassLabel', type: eDivType.label });
    
    //Measurements Panel
    fieldsPage.push({ divName: '', value: 'MESUREMENTS', name: 'tbMeasurements', type: eDivType.div });
    fieldsPage.push({ divName: '', value: 'EXPORT', name: 'exportMeasLog', type: eDivType.button });
    
    //Events Log Panel
    fieldsPage.push({ divName: '', value: 'EVENT LOG', name: 'tbEventsLog', type: eDivType.div });

    fieldsPage.push({ divName: '', value: 'Today', name: 'radioTodayLabel', type: eDivType.radioLabel });
    fieldsPage.push({ divName: '', value: 'Last 7 days', name: 'radioLast7daysLabel', type: eDivType.radioLabel });
    fieldsPage.push({ divName: '', value: 'Last 30 days', name: 'radioLast30daysLabel', type: eDivType.radioLabel });
    fieldsPage.push({ divName: '', value: 'All', name: 'radioAllLabel', type: eDivType.radioLabel }); 
    
    fieldsPage.push({ divName: '', value: 'EXPORT', name: 'exportEventsLog', type: eDivType.button });

    readDataForDiv(fieldsPage,
                   eUrlGet.translate, "POST");
    
}

function loadMeasurements() {

    try {
        var fileName = "MeasLog.csv";

        //Copio il file aggiornato nella cartella httproot/logfiles
        var fileNamePar = [{ name: 'logFileName', value: fileName }, { name: 'exportType', value: 'loadPage'}];
        exportData(fileNamePar, eUrlPost.exportLogFile);

        var columnsModel =  [
   		                { name: 'dateTime', index: 'dateTime', sorttype: "date", datefmt: "Y-m-d h:i:s", width: 140 },
   		                { name: 'In1_V', index: 'In2_V', width: 50 },
                        { name: 'In2_V', index: 'In2_V', width: 50 },
                        { name: 'In3_V', index: 'In3_V', width: 50 },
                        { name: 'Bat_pc', index: 'Bat_pc', width: 50 },
                        { name: 'Bat_V', index: 'Bat_V', width: 50 },
                        { name: 'Out1_V', index: 'Out1_V', width: 50 },
                        { name: 'Out2_V', index: 'Out2_V', width: 50 },
                        { name: 'Out3_V', index: 'Out3_V', width: 50 },
                        { name: 'Lr_pc', index: 'Lr_pc', width: 50 }
                        ];

        var dataTable = loadDataLog(fileName);

        showDataTable(dataTable, columnsModel, "measurementsTable", "pMeasurementsTable", false, eFilterInterval.all);
    }
    catch(err) { }
  }


function loadEventsLog() {
    try {
        var fileName = "EventsLog.csv";

        //Copio il file aggiornato nella cartella httproot/logfiles
        var fileNamePar = [{ name: 'logFileName', value: fileName }, { name: 'exportType', value: 'loadPage'}];
        exportData(fileNamePar, eUrlPost.exportLogFile);

        //Recupero il filtro nei intervalli di date
        var filterInterval = $("input:radio[name=radioInterval]:checked").val();

        var columnsModel = [
                            { name: 'dateTime', index: 'dateTime', sorttype: "date", datefmt: "Y-m-d h:i:s", width: 250 },
                            { name: 'Event', index: 'Event', width: 120 },
                            { name: 'Status', index: 'Status', width: 55 },
                            { name: 'Type', index: 'Type', width: 55, hidden: true }
                            ];

       var dataTable = loadDataLog(fileName);

       showDataTable(dataTable, columnsModel, "eventsLogTables", "pEventsLogTables", false, filterInterval);

    } catch(err) {}

    
}

function barMouseOver(nomeBarra) {
    if (barClicked != nomeBarra) {
        var divName = "#" + nomeBarra;
        $(divName).show();
    }    
}

function barMouseOut(nomeBarra) {
    var divName = "#" + nomeBarra;
    
    $("#barraHelp").hide();
    
    switch (barClicked) {
        case "barraHistory":
        case "barraMeasurements":
        case "barraEventsLog":
            $("#barraConfig").hide();
            break;

        case "barraConfig":
        case "barraEmail":
        case "barraShutDown":
        case "barraMisc":
        case "barraCommunication":
            $("#barraHistory").hide();
            break;
    }
}

function barClick(nomeBarra) {
    barClicked = nomeBarra;

    hideAll();

    var divName = "#" + nomeBarra;
    $(divName).show();

    //Gestione barre
    switch (nomeBarra) {
        case "barraHistory":
        case "barraMeasurements":
        case "barraEventsLog":
            $("#barraHistory").show();
            $("#livello2History").show();
            break;

        case "barraConfig":
        case "barraEmail":
        case "barraShutDown":
        case "barraMisc":
        case "barraCommunication":
            $("#barraConfig").show();
            $("#livello2Config").show();
            break;
    }

    //Gestione pannelli
    switch (nomeBarra) {
        case "barraHistory":
        case "barraMeasurements":
            $("#measurementsPanel").show();
            loadMeasurements();
            break;

        case "barraEventsLog":
            $("#eventsLogPanel").show();
            loadEventsLog();
            break;

        case "barraConfig":
        case "barraEmail":
            readDataForDiv(getFieldsPanelData(nomeBarra),
                            eUrlGet.readUserDbValue);
            
            $("#emailPanel").show();
            break;

        case "barraShutDown":
            readDataForDiv(getFieldsPanelData(nomeBarra),
                            eUrlGet.readUserDbValue);
            
            $("#shutDownPanel").show();
            break;

        case "barraMisc":
            //Populate the control with values received from engine
            readDataForDiv(getFieldsPanelData(nomeBarra),
                            eUrlGet.readUserDbValue);

            $("#miscPanel").show();
            break;

        case "barraCommunication":
            //Populate the control with values received from engine
            readDataForDiv(getFieldsPanelData(nomeBarra),
                            eUrlGet.readCommDbValue);
            
            //Forzo la lettura per la validazione del campo
            $("select#interface").change();

            $("#communicationPanel").show();
            break;
    }
}

function getFieldsPanelData(nomeBarra) {
    var fields = new Array;

    switch (nomeBarra){
        case "barraCommunication":
            fields.push({ name: 'protocol', divName: 'protocol', type: eDivType.selection, value: null});
            fields.push({ name: 'interface', divName: 'interface', type: eDivType.selection, value: null});
            fields.push({ name: 'slaveId', divName: 'slaveId', type: eDivType.selection, value: null});
            fields.push({ name: 'comSpeed', divName: 'comSpeed', type: eDivType.selection, value: null});
            fields.push({ name: 'tcpPort', divName: 'tcpPort', type: eDivType.value, value: null});
            fields.push({ name: 'ipAddress', divName: 'ipAddress', type: eDivType.value, value: null});
            break;

        case "barraMisc":
            fields.push({ name: 'Language', divName: 'languageSelection', type: eDivType.radio, value: null });
            fields.push({ name: 'RecordsDepth', divName: 'dataRecordPeriod', type: eDivType.radio, value: null });
            fields.push({ name: 'SamplingInterval', divName: 'dataSample', type: eDivType.radio, value: null });
            fields.push({ name: 'httpPort', divName: 'httpPort', type: eDivType.value, value: null });
   		    break;

   		case "barraShutDown":
   		    fields.push({ name: 'FirstWarning', divName: 'shutDownFirstWarning', type: eDivType.value, value: null });
   		    fields.push({ name: 'SDDelay', divName: 'shutDownDelay', type: eDivType.value, value: null });
   		    fields.push({ name: 'FirstDelayScriptEnabled', divName: 'cbFirstDelayScript', type: eDivType.checkBox, value: null });
   		    fields.push({ name: 'FirstDelayScript', divName: 'fileFirstDelayScript', type: eDivType.value, value: null });
   		    fields.push({ name: 'SDDelayScriptEnabled', divName: 'cbShutdownCommandScript', type: eDivType.checkBox, value: null });
   		    fields.push({ name: 'SDDelayScript', divName: 'fileShutdownCommandScript', type: eDivType.value, value: null });
   		    fields.push({ name: 'es001enabled', divName: 'shutdownEventOnBattery', type: eDivType.checkBox, value: null });
   		    fields.push({ name: 'es001delay', divName: 'shutdownEventOnBatteryDelayS', type: eDivType.value, value: null });
   		    fields.push({ name: 'es002enabled', divName: 'shutdownEventOverload', type: eDivType.checkBox, value: null });
   		    fields.push({ name: 'es002delay', divName: 'shutdownEventOverloadDelayS', type: eDivType.value, value: null });
   		    fields.push({ name: 'es003enabled', divName: 'shutdownEventOverTemperature', type: eDivType.checkBox, value: null });
   		    fields.push({ name: 'es003delay', divName: 'shutdownEventOverTemperatureDelayS', type: eDivType.value, value: null });
   		    fields.push({ name: 'es004enabled', divName: 'shutdownEventBatteryLow', type: eDivType.checkBox, value: null });
   		    fields.push({ name: 'es004delay', divName: 'shutdownEventBatteryLowDelayS', type: eDivType.value, value: null });
   		    fields.push({ name: 'es005enabled', divName: 'shutdownEventImminentStop', type: eDivType.checkBox, value: null });
   		    fields.push({ name: 'es005delay', divName: 'shutdownEventImminentStopDelayS', type: eDivType.value, value: null });
   		    fields.push({ name: 'es006enabled', divName: 'shutdownEventOnBypass', type: eDivType.checkBox, value: null });
   		    fields.push({ name: 'es006delay', divName: 'shutdownEventOnBypassDelayS', type: eDivType.value, value: null });
   		    fields.push({ name: 'UPS_ShutoffEnabled', divName: 'shutdownUpsShutOff', type: eDivType.checkBox, value: null });
   		    fields.push({ name: 'UPS_SDDelay', divName: 'shutdownUpsShutoffDelay', type: eDivType.value, value: null });
   		    break;

   		    shutdownEventOnBatteryDelayS
   		    
   		case "barraConfig":
        case "barraEmail":
   		    fields.push({ name: 'ServerAddress', divName: 'emailServer', type: eDivType.value, value: null });
   		    fields.push({ name: 'Port', divName: 'emailPort', type: eDivType.value, value: null });
   		    fields.push({ name: 'Account', divName: 'emailAccount', type: eDivType.value, value: null });
   		    fields.push({ name: 'Authentication', divName: 'emailAuthentication', type: eDivType.checkBox, value: null });
   		    fields.push({ name: 'Password', divName: 'emailPassword', type: eDivType.value, value: null });			
			fields.push({ name: 'SenderMailAddress', divName: 'emailSenderMailAddress', type: eDivType.value, value: null });
			fields.push({ name: 'SSL', divName: 'emailSSL', type: eDivType.checkBox, value: null });
			
   		    fields.push({ name: 'DelayInMinutes', divName: 'receiverEmailDelay', type: eDivType.value, value: null });
   		    fields.push({ name: 'IntervalInHours', divName: 'receiverInterval', type: eDivType.value, value: null });
   		    fields.push({ name: 'em001enabled', divName: 'emailEventOnBattery', type: eDivType.checkBox, value: null });
   		    fields.push({ name: 'em001criticityLevel', divName: 'criticalityLevelOnBattery', type: eDivType.selection, value: null });
   		    fields.push({ name: 'em002enabled', divName: 'emailEventOverload', type: eDivType.checkBox, value: null });
   		    fields.push({ name: 'em002criticityLevel', divName: 'criticalityLevelOverload', type: eDivType.selection, value: null });

   		    fields.push({ name: 'em003enabled', divName: 'emailEventOverTemperature', type: eDivType.checkBox, value: null });
   		    fields.push({ name: 'em003criticityLevel', divName: 'criticalityLevelOverTemperature', type: eDivType.selection, value: null });

   		    fields.push({ name: 'em004enabled', divName: 'emailEventGeneralAlarm', type: eDivType.checkBox, value: null });
   		    fields.push({ name: 'em004criticityLevel', divName: 'criticalityLevelGeneralAlarm', type: eDivType.selection, value: null });

   		    fields.push({ name: 'em005enabled', divName: 'emailEventBatteryAlarm', type: eDivType.checkBox, value: null });
   		    fields.push({ name: 'em005criticityLevel', divName: 'criticalityLevelBatteryAlarm', type: eDivType.selection, value: null });

   		    fields.push({ name: 'em006enabled', divName: 'emailEventBatteryDischarged', type: eDivType.checkBox, value: null });
   		    fields.push({ name: 'em006criticityLevel', divName: 'criticalityLevelBatteryDischarged', type: eDivType.selection, value: null });

   		    fields.push({ name: 'em007enabled', divName: 'emailEventImminentStop', type: eDivType.checkBox, value: null });
   		    fields.push({ name: 'em007criticityLevel', divName: 'criticalityLevelImminentStop', type: eDivType.selection, value: null });

   		    fields.push({ name: 'em008enabled', divName: 'emailEventOnBypass', type: eDivType.checkBox, value: null });
   		    fields.push({ name: 'em008criticityLevel', divName: 'criticalityLevelOnBypass', type: eDivType.selection, value: null });

   		    fields.push({ name: 'ReceiverAddress1', divName: 'receiverAddress1', type: eDivType.value, value: null });
   		    fields.push({ name: 'ReceiverDescription1', divName: 'receiverDescription1', type: eDivType.value, value: null });
   		    fields.push({ name: 'ReceiverCriticityLevel1', divName: 'minAlarmCritic1', type: eDivType.selection, value: null });

   		    fields.push({ name: 'ReceiverAddress2', divName: 'receiverAddress2', type: eDivType.value, value: null });
   		    fields.push({ name: 'ReceiverDescription2', divName: 'receiverDescription2', type: eDivType.value, value: null });
   		    fields.push({ name: 'ReceiverCriticityLevel2', divName: 'minAlarmCritic2', type: eDivType.selection, value: null });

   		    fields.push({ name: 'ReceiverAddress3', divName: 'receiverAddress3', type: eDivType.value, value: null });
   		    fields.push({ name: 'ReceiverDescription3', divName: 'receiverDescription3', type: eDivType.value, value: null });
   		    fields.push({ name: 'ReceiverCriticityLevel3', divName: 'minAlarmCritic3', type: eDivType.selection, value: null });

   		    fields.push({ name: 'ReceiverAddress4', divName: 'receiverAddress4', type: eDivType.value, value: null });
   		    fields.push({ name: 'ReceiverDescription4', divName: 'receiverDescription4', type: eDivType.value, value: null });
   		    fields.push({ name: 'ReceiverCriticityLevel4', divName: 'minAlarmCritic4', type: eDivType.selection, value: null });

   		    fields.push({ name: 'ReceiverAddress5', divName: 'receiverAddress5', type: eDivType.value, value: null });
   		    fields.push({ name: 'ReceiverDescription5', divName: 'receiverDescription5', type: eDivType.value, value: null });
   		    fields.push({ name: 'ReceiverCriticityLevel5', divName: 'minAlarmCritic5', type: eDivType.selection, value: null });

   		    fields.push({ name: 'ReceiverAddress6', divName: 'receiverAddress6', type: eDivType.value, value: null });
   		    fields.push({ name: 'ReceiverDescription6', divName: 'receiverDescription6', type: eDivType.value, value: null });
   		    fields.push({ name: 'ReceiverCriticityLevel6', divName: 'minAlarmCritic6', type: eDivType.selection, value: null });

   		    fields.push({ name: 'ReceiverAddress7', divName: 'receiverAddress7', type: eDivType.value, value: null });
   		    fields.push({ name: 'ReceiverDescription7', divName: 'receiverDescription7', type: eDivType.value, value: null });
   		    fields.push({ name: 'ReceiverCriticityLevel7', divName: 'minAlarmCritic7', type: eDivType.selection, value: null });

   		    fields.push({ name: 'ReceiverAddress8', divName: 'receiverAddress8', type: eDivType.value, value: null });
   		    fields.push({ name: 'ReceiverDescription8', divName: 'receiverDescription8', type: eDivType.value, value: null });
   		    fields.push({ name: 'ReceiverCriticityLevel8', divName: 'minAlarmCritic8', type: eDivType.selection, value: null });

   		    break;
    }
    return fields;
}

function hideAll() {
    $("#barraHistory").hide();
    $("#barraConfig").hide();

    $("#livello2History").hide();
    $("#livello2Config").hide();

    $("#measurementsPanel").hide();
    $("#emailPanel").hide();
    $("#eventsLogPanel").hide();
    $("#shutDownPanel").hide();
    $("#miscPanel").hide();
    $("#communicationPanel").hide();
}

function loadDataLog(nomeLog) {
    var dataReturn;

    $.ajax({
        url: exportLogFolderName + '/' + nomeLog,
        type: "GET",
        dataType: "text",
        async: false,
        success: function (data) {
            dataReturn = data;
        }
    });

    return dataReturn;

}

function applyFilterInterval(fullRows, filterInterval) {
    var rowsArray = new Array;
    
    var startDate = new Date;
    var endDate = new Date;

    switch (filterInterval) {
//        case eFilterInterval.all:
//            endDate = null;
//            break;

        case eFilterInterval.today:
            endDate.setDate(startDate.getDate() - 1);
            break;

        case eFilterInterval.days7:
            endDate.setDate(startDate.getDate() - 7);
            break;

        case eFilterInterval.days30:
            endDate.setDate(startDate.getDate() - 30);
            break;
    }

    //Estraggo la data di ogni riga (i primi 10 caratteri)
    $.each(fullRows, function (i, row) {
        var dateSplitted = (row.substring(0, 10)).split('/');
        var dateRow = new Date(dateSplitted[1] + '/' + dateSplitted[0] + '/' + dateSplitted[2]);

        if ((dateRow >= endDate) || (endDate == null) || i == 0) {
            rowsArray.push(row);
        }
    });
    return rowsArray;
}

function showDataTable(fullDataString, columnsModel, divTableName, divPagerName, multiselect, filterInterval) {

    var fullRows = fullDataString.split("\n");

    //Applico l'eventuale filtro sull'intervallo di date
    if (filterInterval != eFilterInterval.all) {
        fullRows = applyFilterInterval(fullRows,filterInterval);
    }

    $("#" + divTableName).jqGrid('GridUnload');

    var columns = new Array();
    rows = new Array();
    var columsTotNumber = columnsModel.length;

    $.each(fullRows, function (i, row) {
        var row = fullRows[i].split(";");

        if (row != ""){ //Se la riga non  vuota
            //***La prima riga della tabella la uso per il nome delle colonne
            if (i == 0) {
                for (j = 0; j < (columsTotNumber); j++) {
                    columns[j] = $.trim(row[j]);
                }
            //***
            } else {
                var datiRiga = new Array();
                for (j = 0; j < (columsTotNumber); j++) {
                    datiRiga[columnsModel[j].name] = $.trim(row[j]);
                }
            rows.push(datiRiga);
            }
        }
        
    });


    $("#" + divTableName).jqGrid({
        data: rows,
        datatype: "local",
        height: 300,
        rowNum: 13,
        colNames: columns,
        colModel: columnsModel,
        pager: "#" + divPagerName,
        viewrecords: true,
        hidegrid: false,
        multiselect: multiselect,
        loadtext: "Loading...",
        afterInsertRow: function (rowid, rowdata) {
            cols = $("#" + divTableName)[0].p.colNames;
            if (rowdata.Type == "A") {
                for (k = 0; k < cols.length; k++) {
                    $("#" + divTableName).setCell(rowid, k, '', { background: '#E8CB44' });
                }
            }
            if (rowdata.Type == "S") {
                for (k = 0; k < cols.length; k++) {
                    $("#" + divTableName).setCell(rowid, k, '', { background: '#ABD559' });
                }
            }
        }

    });

    $("#" + divTableName).trigger("reloadGrid");
}

function getManualClick() {
    data = exportData(null, eUrlPost.getManual);

    if (data != "") {
        startDownload(exportManualsFolderName + '/' + data);
    } else {
        popup(data);
    }
}

function exportDataClick(data2Export) {
    var fileName = null;
    var data = null;

    fileName = [{ name: 'logFileName', value: data2Export }, { name: 'exportType', value: 'exportFile'}];
    data = exportData(fileName, eUrlPost.exportLogFile);

    if (data != "") {
        startDownload(exportLogFolderName + '/' + data);
    } else {
        popup(data);
    }

}

function TryParseInt(str) {
    var retValue = false;
    if (str != null) {
        if (str.length > 0) {
            if (!isNaN(str)) {
                retValue = true;
            }
        }
    }
    return retValue;
}

function isValidIPAddress(ipaddr) {
    var re = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
    if (re.test(ipaddr)) {
        var parts = ipaddr.split(".");
        if (parseInt(parseFloat(parts[0])) == 0) { return false; }
        for (var i = 0; i < parts.length; i++) {
            if (parseInt(parseFloat(parts[i])) > 255) { return false; }
        }
        return true;
    } else {
        return false;
    }
}

function isValidMailAddress(mailaddr) {
    var re = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
    if (re.test(mailaddr)) {
        return true;
    } else {
        return false;
    }    
}

//Popup dialog
function popup(message) {

    // get the screen height and width  
    var maskHeight = $(document).height();
    var maskWidth = $(window).width();

    // calculate the values for center alignment
    var dialogTop = (maskHeight) - ($('#dialog-box').height()) - 300;
    var dialogLeft = (maskWidth / 2) - ($('#dialog-box').width() / 2);

    // assign values to the overlay and dialog box
    $('#dialog-overlay').css({ height: maskHeight, width: maskWidth }).show();
    $('#dialog-box').css({ top: dialogTop, left: dialogLeft }).show();

    // display the message
    $('#dialog-message').html(message);

}

function checkUpdate() {
    $.ajax({
        type: "POST",
        url: eUrlPost.checkUpdate,
        async: true,
        //timeout: 10000,
        error: function () { popup("error"); },
        success: function (data) {
            checkUpdateReturn();
        }
    });
}


function checkUpdateReturn() {
    var returnData;
    $.ajax({
        type: "GET",
        url: eUrlGet.checkUpdate,
        dataType: "JSON",
        async: false,
        //timeout: 10000,
        error: function () { popup("error"); },
        success: function (json) {
            returnData = json;
        }
    });

    if (returnData.ResultID == "IsRunning") {
        
        $("#checkUpdate").button("disable");
        $("#divResultCheckUpdate").hide();
        $("#divCheckingUpdate").show();
        
        document.getElementById("divCheckingUpdate").innerHTML = returnData.ResultText;
        setTimeout('checkUpdateReturn()', 2000);

    } else {
        $("#divCheckingUpdate").hide();

        $("#checkUpdate").button("enable");

        $("#divResultCheckUpdate").show();
        
        if (returnData.Link == "")  {
            $("#linkUpdate").removeAttr('href');
            
            } else {
                $('#linkUpdate').attr('href', returnData.Link);
            }
        
        document.getElementById("linkUpdate").innerHTML = returnData.ResultText;
        }
}

function autoDiscoverCommand() {
    var fieldsCommand = new Array;
    fieldsCommand.push({ name: 'Command', value: 'Autodiscover' });
    sendCommand(fieldsCommand);
}

function sendMailTest() {
    var fieldsCommand = new Array;
    fieldsCommand.push({ name: 'Command', value: 'MailTest' });
    sendCommand(fieldsCommand);
}

function startShutdownTest() {
    var fieldsCommand = new Array;
    fieldsCommand.push({ name: 'Command', value: 'Shutdown' });
    sendCommand(fieldsCommand);

    $("#startShutdownTest").button("disable");

    $("#cancelShutdownTest").button("enable");

    //Recupero il tempo massimo del comando
    var fields = new Array;
    
    fields.push({ name: 'es001delay', divName: 'shutdownEventOnBatteryDelayS', type: eDivType.value, value: null });
    fields.push({ name: 'SDDelay', divName: 'shutDownDelay', type: eDivType.value, value: null });

    fields = getValuesFromPanel(fields);

    //Validazione dei dati inseriti
    var sddelay, es001dealy;

    var valOk = true;
    $.each(fields, function (i, field) {
        switch (field.name) {
            case "SDDelay":
                if ((TryParseInt(field.value) == false) && (!field.value)) {
                    $("label#shutDownDelay_error").show();
                    $("input#shutDownDelay").focus();
                    valOk = false;
                } else {
                    sddelay = field.value;
                }

                break;

            case "es001delay":
                if ((TryParseInt(field.value) == false) && (!field.value)) {
                    $("label#es001delay_error").show();
                    $("input#es001delay").focus();
                    valOk = false;
                } else {
                    es001dealy = field.value;
                }
                break;
        }
    });

    if (valOk == false) return false;

    //Calcolo il valore, che verr usato come timeout
    var timeout = (parseInt(sddelay) + parseInt(es001dealy)) * 1000;

    //Una volta consumato il time out lancia un comando di cancel test
    setTimeout('enableShutDownTest()', timeout);
}

function cancelShutdownTest() {
    var fieldsCommand = new Array;
    fieldsCommand.push({ name: 'Command', value: 'ShutdownCancel' });
    sendCommand(fieldsCommand);

    enableShutDownTest();
}

function enableShutDownTest() {
    $("#startShutdownTest").button("enable");
    $("#cancelShutdownTest").button("disable");
}