
//2012 - SOCOMEC SICON S.r.l.

//*****************************
//GLOBAL VARS
//*****************************


var eDivType = { //div type to replace content
                "selection": "selection",
                "value": "value",
                "div" : "div",
                "label": "label",
                "button": "button",
                "radio": "radio",
                "radioLabel": "radioLabel",
                "checkBox": "checkBox"
                };

var eUrlGet = { //servlets to use for ReadDataForDiv
                "readInstruments": "ReadGuiBridgeInstruments.vsp",
                "readAlarms": "ReadGuiBridgeAlarms.vsp",
                "readCommDbValue": "StoreCommDataServlet.vsp",
                "readUserDbValue": "StoreUserDataServlet.vsp",
                "translate":"LanguageServlet.vsp",
                "dropDown": "CommDropDownServlet.vsp",
                "checkUpdate": "CheckForNewVersionServlet.vsp",
                "infoVersion": "InfoVersionServlet.vsp",
                "updateGUIFlow": "Synop_UpdateGUIFlow.vsp",
				"updateGUIImages": "Synop_UpdateGUIImages.vsp",
				"updateGUIValues": "Synop_UpdateGUIValues.vsp"
            };

var eUrlPost = { //servlets to use for saveData
                "saveCommDbValue": "StoreCommDataServlet.vsp",
                "saveUserDbValue": "StoreUserDataServlet.vsp",
                "exportLogFile": "ExportHistoryDataServlet.vsp",
                "checkUpdate": "CheckForNewVersionServlet.vsp",
                "sendCommand": "SendCommandServlet.vsp",
                "getManual": "GetManualServlet.vsp"
            };

var eFilterInterval = {
                "all": "all",
                "today": "today",
                "days7": "days7",
                "days30": "days30"
            };

var eActionExported = {
                "donwload": "donwload",
                "filter": "filter"
            };

var tool = new function (_name, _description, _value, _unit, _extra) {
    this.name = _name;
    this.description = _description;
    this.value = _value;
    this.unit = _unit;
    this.extra = _extra;
    
}

var s = new Array( //Strumenti 
            new Array(), new Array(), new Array(), new Array(), new Array(), new Array(), new Array(), new Array()
            );

var a = ""; // Allarmi

var exportLogFolderName = "LogFiles";
var exportManualsFolderName = "Manuals";

//*****************************
//PAGE FUNCTIONS
//*****************************

function toggleEnableSelectStart(enable) {
    document.onmousedown = function (e) {return enable;};
    document.onselectstart = function (e) { return enable; };
}

function disableControlsSelection() {
    
    //Disable default text selection behavior
    toggleEnableSelectStart(false);

    //for inputs it must be possible to select text
    jQuery("input[type=text]").focusin(function () { toggleEnableSelectStart(true); });
    jQuery("input[type=text]").mouseover(function () { toggleEnableSelectStart(true); });
    jQuery("input[type=text]").focusout(function () { toggleEnableSelectStart(false); });
    jQuery("input[type=text]").mouseout(function () { toggleEnableSelectStart(false); });

    //for inputs password it must be possible to select text
    jQuery("input[type=password]").focusin(function () { toggleEnableSelectStart(true); });
    jQuery("input[type=password]").mouseover(function () { toggleEnableSelectStart(true); });
    jQuery("input[type=password]").focusout(function () { toggleEnableSelectStart(false); });
    jQuery("input[type=password]").mouseout(function () { toggleEnableSelectStart(false); });

    //for select it must be possible to select
    jQuery("select").focusin(function () { toggleEnableSelectStart(true); });
    jQuery("select").mouseover(function () { toggleEnableSelectStart(true); });
    jQuery("select").focusout(function () { toggleEnableSelectStart(false); });
    jQuery("select").mouseout(function () { toggleEnableSelectStart(false); });
}

window.onload = function () {
    setTimeout('hideSplash()', 800);
}

$(window).load(function () {
    //$(document).ready(function() {
	
    $('#mainBody').hide();

    disableControlsSelection();
    pageTranslate();

    showVersion();

    loadPanels();

    setTimeout('hideSplash()', 2000);

    setTimeout('clockViewer()', 500);
    setTimeout('clockUpperBar()', 500);
});



//*****************************
//COMMON FUNCTIONS
//*****************************

function clockUpperBar() {

    // ---------------------
    // Instruments Request
    // ---------------------

    $.ajax({
        url: eUrlGet.readInstruments,
		timeout: 4000,
        data: "parameterName=changes",
        cache: false,
        type: "GET",
        dataType: "text",
        async: false,
        error: function () {
            serviceDownUpperBar();
        },
        success: function (data) {
            changesEnhancing(data);
            serviceUpUpperBar(data);
        }
    });

    // ---------------------
    // No Alarms request for the Expert
    // ---------------------	

    setTimeout('clockUpperBar()', 5000);
}


function showVersion() {
    var fieldsVersion = new Array;
    fieldsVersion.push({ divName: 'divInfoVersion', value: 'infoVersion', name: '', type: eDivType.div });

    readDataForDiv(fieldsVersion, eUrlGet.infoVersion);
}

function populateCbo (cboName) {

    var dataStringForGetCbo = cboName + "="; ;
    var divName = "#" + cboName;

    //Eseguo la chiamata all'engine
    $.ajax({
        type: "GET",
        url: eUrlGet.dropDown,
        dataType: "JSON",
        data: dataStringForGetCbo,
        success: function (json) {
            $(divName).empty();
            $.each(json, function (q, fieldResult) {
                $(divName).append(
                        $('<option></option>').val(fieldResult.value).html(fieldResult.name)
                    );
            });
        }
    });
}


function hideSplash() {
    $('#startSplash').fadeOut("slow", function () {
        $('#mainBody').fadeIn("fast");
        $('#contentStartSplash').fadeOut("fast");
        });
}



function changesEnhancing(data) {
    var splitData = data.split(";");
    Tools= new Array();
    var elementsNumberOfS = 5;

    var rowListCountOfS = ((splitData.length - 1) / elementsNumberOfS);

    for (i = 0; i < rowListCountOfS; i++) {
        Tools[i] = new Array();
        for (j = 0; j < elementsNumberOfS; j++) {
                Tools[i][j] = splitData[(i * elementsNumberOfS) + j];
            }
		
			if (s[i] == null)
			{
				toolEnhancing(Tools[i]);
				s[i] = Tools[i];
			}
			else
			{
				//Valorizzo la variabile globale s[i] solo se il dato  cambiato
				if (Tools[i].toString() != s[i].toString()) {				
					toolEnhancing(Tools[i]);
					s[i] = Tools[i];
				}
			}		
		
        }
        
    }

function toolEnhancingUpperBar(data) {
    
    tool.name = data[0];
    tool.description = data[1];
    tool.value = data[2];
    tool.unit = data[3];
    tool.extra = data[4];

    switch (tool.name) {

        //Backup Time Section
        case "s1":		
			/*		
            if (tool.extra == "Visible")
			{
                document.getElementById("backupTimeDescriptionUpperBar").innerHTML = tool.description + ":";
                document.getElementById("backupTimeValueUpperBar").innerHTML = tool.value + " " + tool.unit;
            }
			else
			*/
			{			
                document.getElementById("backupTimeDescriptionUpperBar").innerHTML = "";
                document.getElementById("backupTimeValueUpperBar").innerHTML = "";
            }
			
            break;			

        //Load Rate Section 
        case "s3":			
            document.getElementById("loadRateDescriptionUpperBar").innerHTML = tool.description + ":";
            document.getElementById("loadRateValueUpperBar").innerHTML = tool.value + " " + tool.unit;
			
            break;						

        //Local View icon  
        case "s5":			
            switch (tool.value) {
                case "BLUE": //Se l'icona  BLUE (no communication) nascondo il valore nell'upper bar
                    hideLoadRateAndBackupTime();
                    
                    break;
                case "MAGENTA":
                    hideLoadRateAndBackupTime();
                    break;
                default:
                    showLoadRateAndBackupTime();			                    
			break;
            }			

            document.getElementById("localViewIconDescription").innerHTML = tool.description;
            changeImage("localViewIconImgs", tool.value + "-icon");
            break;			
        
    }
}

function changeImage(imagesId, nextImageId, speed) {
    //$("#" + imagesId).show();
    var $activeImg = $("#" + imagesId + " .active");

    var $nextImg = $("#" + nextImageId);

    if (($activeImg[0] != undefined)) { //verifico se la classe active  associata a un immagine, altrimento da un eccezione
        $activeImg.fadeOut(speed, function () {
            $activeImg.removeClass('active');
            $nextImg.fadeIn(speed).addClass('active');
        });
    } else {
        $nextImg.fadeIn(speed).addClass('active');
    }

    
}

function loadingText() { //Uso questo funzione per visualizzare la barra rossa di loading quando ci sono chiamate Ajax
    
    //Per la release lo nascondo sempre
    $("#loading").hide();

    //usato solo per debug
    /* 
    $("#loading").bind
    (
    "ajaxSend", function () {
        $(this).show();
    }
    ).bind("ajaxComplete", function () {
        $(this).hide();
    }
    );
    */
}

function createDataString(fields) {
    var dataString = "";

    //Costruisco i dati da chiedere
    $.each(fields, function (i, field) {
        if (i != 0) { //al primo campo non devo mettere la & commerciale
            dataString = dataString + "&";
        }
        dataString = dataString + field.name + "=" + field.value;
    });

    return dataString;
}

function readDataForDiv(fields, urlGet, verb) {

    var dataStringForGet = createDataString(fields);

    //Eseguo la chiamata all'engine
    $.ajax({
        type: verb == undefined ? "GET" : verb,
        url: urlGet,
        dataType: "JSON",
        data: dataStringForGet,
        success: function (json) {
            switch (urlGet) {
                //Gestisco la popolazione dei campi da tradurre
                case eUrlGet.translate: 
                    $.each(fields, function (k, field) {
                        $.each(json, function (q, fieldResult) {
                            if (field.name == fieldResult.name) {
                                setDiv(field.name, field.type, fieldResult.value); //Popolo il div corrispondente
                            }
                        });
                    });
                    break;
                
                default: //tutti gli atri casi (dati dei controlli...)
                    $.each(fields, function (k, field) {
                        $.each(json, function (q, fieldResult) {
                            if (field.name == fieldResult.name) {
                                setDiv(field.divName, field.type, fieldResult.value); //Popolo il div corrispondente
                                divRule(field.divName);
                            }
                        });
                    });
                    break;
            }
        },
		error: function () {
			console.log('error');
		}
    });
}

function divRule(divName) {

    switch (divName) {
        case "interface":
            var sSelectedItem = $("select#interface option:selected").val().toLowerCase();
			var sSelectedProtocol = $("select#protocol option:selected").val().toLowerCase();

            if (sSelectedItem){
             switch (true) {
                    case (sSelectedItem.indexOf("/dev/cu.") == 0):
                    case (sSelectedItem.indexOf("/dev/tty.") == 0): // Mac serial
                    case (sSelectedItem.indexOf("/dev/ttys") == 0): // Linux serial
                    case (sSelectedItem.indexOf("/dev/ttyusb") == 0): // Linux serial
                    case (sSelectedItem.indexOf("com") == 0):
                        $('select#slaveId').removeAttr("disabled");
                        $('select#comSpeed').removeAttr("disabled");
                        $('input#tcpPort').attr("disabled", true);
                        $('input#ipAddress').attr("disabled", true);
                        //$('select#protocol').val('JBUS-P');
                        //$('select#comSpeed').val('9600');
                        break;

                    case (sSelectedItem == "eth"):
                        $('select#slaveId').removeAttr("disabled");
                        $('select#comSpeed').attr("disabled", true);
                        $('input#tcpPort').removeAttr("disabled");
                        $('input#ipAddress').removeAttr("disabled");
                        break;

                    case (sSelectedItem == "usb"):					
                        $('select#slaveId').attr("disabled", true);
                        $('select#comSpeed').attr("disabled", true);
                        $('input#tcpPort').attr("disabled", true);
                        $('input#ipAddress').attr("disabled", true);
						if (sSelectedProtocol != "jbus-ph" && sSelectedProtocol != "jbus-ph2")
						{
							$('select#protocol').val('JBUS-PH');
						}
                        break;
                }
        }
         
           
            break;

        case "dataRecordPeriod":
            
            var samplingPeriod = $("input:radio[name=dataRecordPeriod]:checked").val();
            var _SamplingInterval = $("input:radio[name=dataSample]:checked").val();

            var MIN_DAY_SAMPLINGINTERVAL = 1;
            var MIN_WEEK_SAMPLINGINTERVAL = 10;
            var MIN_MONTH_SAMPLINGINTERVAL = 30;

            var MinSamplingInterval = 0;

            $('input#dataSample_1').attr("disabled", true);
            $('input#dataSample_1').removeAttr("disabled");

            $('input#dataSample_1').removeAttr("disabled");
            $('input#dataSample_2').removeAttr("disabled");
            $('input#dataSample_5').removeAttr("disabled");
            $('input#dataSample_10').removeAttr("disabled");
            $('input#dataSample_20').removeAttr("disabled");
            $('input#dataSample_30').removeAttr("disabled");
            $('input#dataSample_60').removeAttr("disabled");

            switch (samplingPeriod)
            {
                case "Day":
                    MinSamplingInterval = MIN_DAY_SAMPLINGINTERVAL;
                    break;

                case "Week":
                    MinSamplingInterval = MIN_WEEK_SAMPLINGINTERVAL;
                    $('input#dataSample_1').attr("disabled", true);
                    $('input#dataSample_2').attr("disabled", true);
                    $('input#dataSample_5').attr("disabled", true);
                    break;

                case "Month":
                    MinSamplingInterval = MIN_MONTH_SAMPLINGINTERVAL;
                    $('input#dataSample_1').attr("disabled", true);
                    $('input#dataSample_2').attr("disabled", true);
                    $('input#dataSample_5').attr("disabled", true);
                    $('input#dataSample_10').attr("disabled", true);
                    $('input#dataSample_20').attr("disabled", true);
                    break;
            }

            if (_SamplingInterval < MinSamplingInterval)
            {
                switch (MinSamplingInterval)
                {
                    case MIN_DAY_SAMPLINGINTERVAL:
                        $("#dataSample_1").attr("checked", "checked");
                        break;
                    case MIN_WEEK_SAMPLINGINTERVAL:
                        $("#dataSample_10").attr("checked", "checked");
                        break;
                    case MIN_MONTH_SAMPLINGINTERVAL:
                        $("#dataSample_30").attr("checked", "checked");
                        break;
                }
            }


            break;

        case "cbFirstDelayScript":
            if ($("input#cbFirstDelayScript").attr("checked")) {
                $('input#fileFirstDelayScript').removeAttr("disabled");
                return;
            } else {
                $('input#fileFirstDelayScript').attr("disabled", true);
            }
            break;

        case "cbShutdownCommandScript":
            if ($("input#cbShutdownCommandScript").attr("checked")) {
                $('input#fileShutdownCommandScript').removeAttr("disabled");
                return;
            } else {
                $('input#fileShutdownCommandScript').attr("disabled", true);
            }
            break;
    }
}

function saveData(fields, urlPost) {
    
    var dataStringForPost = createDataString(fields);

    //Eseguo la chiamata all'engine
    $.ajax({
        type: "POST",
        url: urlPost,
        data: dataStringForPost,
        async: false,
        //timeout: 10000,
        error: function () {popup("error");},
        success: function (data) {
                popup(data);
        }
    });
}

function exportData(fields, urlPost) {
    var dataToReturn = null;

    var dataStringForPost = ""; 
    if (fields != null) dataStringForPost = createDataString(fields);

    //Eseguo la chiamata all'engine
    $.ajax({
        type: "POST",
        url: urlPost,
        data: dataStringForPost,
        async: false,
        //timeout: 10000,
        error: function () { popup("error"); },
        success: function (data) {
            dataToReturn = data;
        }
    });

    return dataToReturn;
}

function startDownload(urlFileName) {
    window.location.href = urlFileName;
}

function setDiv(divName, divType, value) {
    switch (divType) {
        case eDivType.value:
            $("input#" + divName).val(value);
            break;

        case eDivType.selection:
            $("select#" + divName).val(value);
            break;

        case eDivType.div:
            document.getElementById(divName).innerHTML = value;
            break;

        case eDivType.button:
            $("#" + divName).button('option', 'label', value);
            break;

        case eDivType.label:
            $("#" + divName).text(value);
            break;

        case eDivType.radio:
            $("#" + divName + "_" + value).attr("checked", "checked");
            break;

        case eDivType.radioLabel:
            $("#" + divName).html('<span class="ui-button-text">' + value + '</span>');
            
            break;

        case eDivType.checkBox:
            if (value == "ENABLED") { $("#" + divName).prop("checked", true) }
            else { $("#" + divName).prop("checked", false) };
            break;
            
    }
}




function showMainDivContent() {
    $("#mainDivContent").show();

    //showLoadRateAndBackupTime();
}



function hideLoadRateAndBackupTime() {
    $("#loadRateDescriptionUpperBar").hide();
    $("#loadRateValueUpperBar").hide();
    $("#backupTimeDescriptionUpperBar").hide();
    $("#backupTimeValueUpperBar").hide();
    $("#loadRateSeparatorUpperBar").hide();
    $("#backupTimeSeparatorUpperBar").hide();
}

function showLoadRateAndBackupTime() {
    $("#loadRateDescriptionUpperBar").show();
    $("#loadRateValueUpperBar").show();
    $("#backupTimeDescriptionUpperBar").show();
    $("#backupTimeValueUpperBar").show();
    $("#loadRateSeparatorUpperBar").show();
    $("#backupTimeSeparatorUpperBar").show();
}

function serviceDownUpperBar() {

    hideLoadRateAndBackupTime();

    document.getElementById("localViewIconDescription").innerHTML = "Service Down";
    changeImage("localViewIconImgs", "WHITE-icon");

    s = [[], [], [], [], [], [], [], []];
}

function serviceDownViewer() {
    hideMainDivContent();
}


function serviceUpUpperBar(data) {
    //Magenta = shutdown in corso; BLUE: no comunication
    if ((s[5][2] != 'MAGENTA') && (s[5][2] != 'BLUE')) {
        showLoadRateAndBackupTime();
    }
    
}

function serviceUpViewer(data) {
    if ((s[5][2] != 'MAGENTA') && (s[5][2] != 'BLUE')) {
        $("#mainDivContent").show();
    }
}



function sendCommand(fields) {
    var dataStringForPost = createDataString(fields);

    $.ajax({
        type: "POST",
        url: eUrlPost.sendCommand,
        dataType: "JSON",
        data: dataStringForPost,
        async: true
        //timeout: 10000,
        //error: function () { popup("error"); },
        //        success: function (data) {
        //            $("input#checkUpdate").attr("disabled", "disabled");
        //            checkUpdateReturn();
        //        }
    });
}