
//2012 - SOCOMEC SICON S.r.l.

//*****************************************************************************************************
//PAGE FUNCTIONS
//*****************************************************************************************************

$(document).ready(function () {
    $('#upbar').load('upbar.html');

    loadingText();

    //loadRateTankLevelling(130);
    //greenTankCharging();
});

//**************************************************************************************************** 
//VIEWER FUNCTIONS
//****************************************************************************************************


function clockViewer() {

    // ---------------------
    // Instruments Request
    // ---------------------


    $.ajax({
        url: eUrlGet.readInstruments,
		timeout: 4000,
        data: "parameterName=changes",
        cache: false,
        type: "GET",
        dataType: "text",
        async: false,
        error: function () {
            serviceDownViewer();
        },
        success: function (data) {
            changesEnhancing(data);
            serviceUpViewer(data);
        }
    });	

    // ---------------------
    // Alarms request
    // ---------------------

    $.ajax({
        url: eUrlGet.readAlarms,
		timeout: 4000,
        data: "parameterName=changes",
        cache: false,
        type: "GET",
        dataType: "text",
        async: false,
        error: function () {
            serviceDownViewer();
        },
        success: function (data) {
            alarmsEnhancing(data);
        }
    });

    // ---------------------
    // FlowBlocks request
    // ---------------------

    $.ajax({
        url: eUrlGet.updateGUIFlow,
        timeout: 4000,
        data: "parameterName=changes",
        cache: false,
        type: "GET",
        dataType: "text",
        async: false,
        error: function () {
            serviceDownViewer();
        },
        success: function (data) {
            setFlowBlocks(data);
        }
    });

	// ---------------------
    // GUI Images request
    // ---------------------

    $.ajax({
        url: eUrlGet.updateGUIImages,
        timeout: 4000,
        data: "parameterName=changes",
        cache: false,
        type: "GET",
        dataType: "text",
        async: false,
        error: function () {
            serviceDownViewer();
        },
        success: function (data) {
            setSynopImgs(data);
        }
    });
	
	// ---------------------
    // GUI Values request
    // ---------------------

    $.ajax({
        url: eUrlGet.updateGUIValues,
        timeout: 4000,
        data: "parameterName=changes",
        cache: false,
        type: "GET",
        dataType: "text",
        async: false,
        error: function () {
            serviceDownViewer();
        },
        success: function (data) {            
			setSynopValues(data);
        }
    });	
	
    setTimeout('clockViewer()', 5000);
}

function loadPanels() {
    //Visualizza la versione

}

function toolEnhancing(data) {
    toolEnhancingUpperBar(data);
    toolEnhancingViewerBox(data);
}

$(document).ready(function () {

});

function pageTranslate() {
}

function rotateAlarms() {
    var $active = $('#alarmsList .active');
    var $next = ($('#alarmsList .active').next().length > 0) ? $('#alarmsList .active').next() : $('#alarmsList div:first');

    $active.fadeOut(function () {
        $active.removeClass('active');
        $next.fadeIn().addClass('active');
    });

    exeRotateAlarms = setTimeout('rotateAlarms()', 2000);
}

function rotateAlarms() {
    var $active = $('#alarmsList .active');
    var $next = ($('#alarmsList .active').next().length > 0) ? $('#alarmsList .active').next() : $('#alarmsList div:first');

    $active.fadeOut(function () {
        $active.removeClass('active');
        $next.fadeIn().addClass('active');
    });

    exeRotateAlarms = setTimeout('rotateAlarms()', 2000);
}

function alarmsEnhancing(data) {
    if (data != a) {
        a = data;
        var alarmsList = a.split(";");
        createAlarmsList(alarmsList);    
    }
}

function createAlarmsList(alarmsArray) {

    var $container = $('#alarmsList');

    switch (alarmsArray[0]) {
        case "noAlarms":
            try {
                clearTimeout(exeRotateAlarms);
            } catch (err) { }

            $container.empty();

            $("#messageBox").hide();
            break;

        default:

            $("#messageBox").show();
            try {
                clearTimeout(exeRotateAlarms); //Stoppo la rotazione degli allarmi
            } catch (err) { }
            
            $container.empty(); //Cancello il contenuto del div (l'elenco degli allarmi)            			
			
            for (i = 0; i < (alarmsArray.length - 1); i= i+2) {
                if (i == 0) {					
                    /*$container.append("<div class='active'><h1>" + alarmsArray[i] + "&#160;</h1><h2>" + alarmsArray[(i + 1)] + "</h2></div>");*/
					$container.append("<div class='active'><h1 class='setInline'>" + alarmsArray[i] + "&#160;</h1><h2 class='setInline'>" + alarmsArray[(i + 1)] + "</h2></div>");
                } else {
                    /*$container.append("<div><h1>" + alarmsArray[i] + "&#160;</h1><h2>" + alarmsArray[(i + 1)] + "</h2></div>");*/
					$container.append("<div><h1 class='setInline'>" + alarmsArray[i] + "&#160;</h1><h2 class='setInline'>" + alarmsArray[(i + 1)] + "</h2></div>");
                }
            }
            
            if (alarmsArray.length > 3) { //se c'è più di un allarme
                rotateAlarms();
            }
    }
}

function toolEnhancingViewerBox(data) {

    tool.name = data[0];
    tool.description = data[1];
    tool.value = data[2];
    tool.unit = data[3];
    tool.extra = data[4];

    switch (tool.name) {

        //UPS Section 
        case "s0":
            document.getElementById("upsDescriptionMain").innerHTML = tool.description;
            document.getElementById("upsPower").innerHTML = tool.value + " " + tool.unit;
            changeImage("upsImgs", tool.extra, 600);
            break;

        //Backup Time Section 
        case "s1":
		
			/*
            if (tool.extra == "Visible") {
                document.getElementById("backupTimeDescription").innerHTML = tool.description;
                document.getElementById("backupTimeValue").innerHTML = tool.value + " " + tool.unit;
            } else {
                document.getElementById("backupTimeDescription").innerHTML = "";
                document.getElementById("backupTimeValue").innerHTML = "";
            }
			*/
            break;

        //Battery Section
        case "s2":
			/*
            document.getElementById("batteryDescription").innerHTML = tool.description;
            document.getElementById("batteryValue").innerHTML = tool.value;
            document.getElementById("batteryUnit").innerHTML = tool.unit;
            //Reimposto l'animazione della tanica della batteria
            batteryAnimation(tool.extra);

            if (tool.extra == "BatteryNotConnected") {
                $("#divBatteryTextValue").hide();
            } else {
                $("#divBatteryTextValue").show();
            }
			*/

            break;

        //Load Rate Section 
        case "s3":
			/*
            document.getElementById("loadRateValue").innerHTML = tool.value;
            document.getElementById("loadRateUnit").innerHTML = tool.unit;
            document.getElementById("loadRateDescription").innerHTML = tool.description;
            //Animazione Tank Load rate
            loadRateTankLevelling(tool.value);
			*/
            break;

        //Status bar 
        case "s4":
            document.getElementById("upsStatusDescription").innerHTML = tool.description;
            changeImage("statusImgs", tool.value);
            break;

        //Local view icon
        case "s5":
            switch (tool.value) {
                case "BLUE": //Se l'icona è BLUE (no communication) nascondo il main div content del viewer
                    hideMainDivContent();
                    break;
                
                default:
                    $("#mainDivContent").show();
                    break;
            }
            break;

        //ACK Allarm 
        case "s6":
            if (tool.value == "Visible") {
                $("#ackButton").show("slow"); //Visualizzo l'allarme ACK    
				$("#alarmPrevIcon").show("slow"); //Visualizzo l'icona Alarm prev
            } else {
                $("#ackButton").hide("slow");
				$("#alarmPrevIcon").hide("slow");
            }
            break;

        //Battery test  
        case "s7":
            if (tool.value == "Visible") {
                $("#batteryTestButton").show("slow"); //Visualizzo l'allarme ACK    
            } else {
                $("#batteryTestButton").hide("slow");
            }
            break;

    }
}

function hideMainDivContent() {
    $("#mainDivContent").hide();
    //s = [[], [], [], [], [], [],[],[]];

    //hideLoadRateAndBackupTime();
}

function batteryAnimation(status) {

    $("#batteryTank").stop();

    try {
        clearTimeout(exe);
    } catch (err) { }

    $("#emptyBatteryTank").show();
    $("#batteryLabels").show();

    switch (status) {
        case "BatteryNotPresent":
            $("#emptyBatteryTank").hide();
            $("#batteryLabels").hide();
            break;
        case "BatteryCapacityNotAvailableWithBV":
            greenTankLevelling("100");
            break;
        case "BatteryCapacityNotAvailable":
            $("#batteryLabels").hide();
            greenTankLevelling("100");
            break;
        case "BatteryNotConnected":
            notConnectedTank();
            break;
        case "BatteryDischarged":
            redTank();
            break;
        case "BatteryDischarging":
            yellowTankDischarging();
            break;
        case "BatteryCharging":
            greenTankCharging();
            break;
        case "BatteryOK":
            greenTankLevelling(tool.value);
            break;

    }
}

function greenTankCharging() {
    changeImage("batteryTankImgs", "batteryGreenTank", 0);

    $("#batteryTank").animate({
        marginTop: "51px"
    }, 0);

    $("#batteryTank").animate({
        marginTop: "0px"
    }, 3000);

    exe = setTimeout('greenTankCharging()', 3000);
}

function yellowTankDischarging() {

    changeImage("batteryTankImgs", "batteryYellowTank", 0);

    $("#batteryTank").animate({
        marginTop: "0px"
    }, 0);

    $("#batteryTank").animate({
        marginTop: "46px"
    }, 3000);

    exe = setTimeout('yellowTankDischarging()', 3000);
}

function redTank() {
    changeImage("batteryTankImgs", "batteryRedTank", 0);

    $("#batteryTank").css("marginTop", "46px");
    $("#batteryTank").css("height", "10px");
}

function notConnectedTank() {
    changeImage("batteryTankImgs", "batteryNotConnected", 0);

    $("#batteryTank").css("marginTop", "0px");
    $("#batteryTank").css("height", "56px");

}

function greenTankLevelling(value) {
    var $height;
    var $marginTop;
    var $recalculatedValue = 0;
    
    changeImage("batteryTankImgs", "batteryGreenTank", 0);

    if (value > 60) {
        $recalculatedValue = ((value - 60) * 100) / 40;
    }
    
    $height = (Math.floor(($recalculatedValue * 56) / 100));
    $marginTop = 56 - $height;

    $height += "px";
    $marginTop += "px";

    $("#batteryTank").animate({
        marginTop: $marginTop
    }, 800);
}

function loadRateTankLevelling(value) {
    var $height;
    var $marginTop;
    var $usingValue;

    $usingValue = value;

    switch (true) {
        case (value <= 90):
            changeImage("loadRateTankImgs", "blueLoadRateTank", 1);
            break;

        case ((value > 90) && (value <= 120)):
            changeImage("loadRateTankImgs", "yellowLoadRateTank", 1);
            break;

        case (value > 120):
            $usingValue = 130;
            changeImage("loadRateTankImgs", "redLoadRateTank", 1);
            break;
    }


    $height = (Math.floor(($usingValue * 59) / 130)) + 1;
    $marginTop = 59 - $height;

    $marginTop += "px";

    $("#loadRateTankDiv").animate({
        marginTop: $marginTop
    }, 800);

}

function hideAckButton() {
    
    var fieldsCommand = new Array;
    fieldsCommand.push({ name: 'Command', value: 'Buzzer_off' });
    sendCommand(fieldsCommand);
    
    $("#ackButton").hide("slow");
}


function testBatteryCommand() {
    var fieldsCommand = new Array;
    fieldsCommand.push({ name: 'Command', value: 'Immediate_battery_test'});
    sendCommand(fieldsCommand);
}





